<?php
// 外部からのアクセス禁止
// - HTTP_SEC_FETCH_SITE : same-origin
if( array_key_exists('HTTP_SEC_FETCH_SITE',$_SERVER) ){
	if( $_SERVER['HTTP_SEC_FETCH_SITE'] != 'same-origin' ){
		echo '#Error - not the same server';
		exit;
	}
}else {
	// - HTTP_REFERER : アクセス元URL <- 例) http://suwa.pupu.jp/HSP/sample2/sample2.html
	// - SERVER_NAME : server domain <- 例) suwa.pupu.jp
	if( !array_key_exists('HTTP_REFERER',$_SERVER) || !array_key_exists('SERVER_NAME',$_SERVER) || parse_url($_SERVER['HTTP_REFERER'])['host'] !== $_SERVER['SERVER_NAME'] ){
		// - ローカルは許容
		if( !array_key_exists('REMOTE_ADDR',$_SERVER) || (substr($_SERVER['REMOTE_ADDR'],0,7) != '127.0.0' && substr($_SERVER['REMOTE_ADDR'],0,7) != '192.168') ){
			echo '#Error - not the local server';
			exit;
		}
	}
}

$postFunc = $_POST['func'];

if($postFunc == 'load'){
	echo func_load( $_POST['key'] );
	exit;
}else if($postFunc == 'save'){
	echo func_save( $_POST['key'], $_POST['val'] );
	exit;
}else if($postFunc == 'sql'){
	echo func_sql( $_POST['key'], $_POST['val'], false );
	exit;
}else if($postFunc == 'sql_json'){
	echo func_sql( $_POST['key'], $_POST['val'], true );
	exit;
}

// ezphp_load
function func_load( $postKey ){
	if(!preg_match("/^save\//", $postKey)){
		return '#Error - no save folder selected';
	}
	if(!preg_match("/^[A-Za-z0-9\/\-\._]+$/", $postKey) || preg_match("/\.\.\//", $postKey)){
		return '#Error - invalid file name';
	}
	if(!file_exists($postKey)){
		return '#Error - file not found';
	}
	$retVar = '';
	$fp = fopen($postKey, 'r');
	if(flock($fp, LOCK_SH)){
		$fileSize = filesize($postKey);
		if($fileSize > 0){
			$retVar = fread($fp, $fileSize);
		} else {
			$retVar = '';
		}
		flock($fp, LOCK_UN);
	} else {
		$retVar = '#Error - failed to open file';
	}
	fclose($fp);
	if(isset($_POST['crc'])){
		return 'CRC32b:'.hash('crc32b', $retVar).'#'.$retVar;
	}
	return $retVar;
}
// ezphp_save
function func_save( $postKey, $postVal ){
	if(!preg_match("/^save\//", $postKey)){
		return '#Error - no save folder selected';
	}
	if(!preg_match("/^[A-Za-z0-9\/\-\._]+$/", $postKey) || preg_match("/\.\.\//", $postKey)){
		return '#Error - invalid file name';
	}
	$pathInfo = pathinfo($postKey);
	$directoryPath = $pathInfo['dirname'];
	if(!is_dir($directoryPath)){
		mkdir($directoryPath, 0777, true);
	}
	if(!file_exists($postKey)){
		$fp = fopen($postKey,"w");
		if($fp == false)
			return '#Error - Could not create file';
		flock($fp,2);
		fputs($fp,"");
		fclose($fp);
		chmod($postKey,0644);
	}
	$retVar = '';
	if(!isset($_POST['crc'])){
		$fp = fopen($postKey, 'w');
		if(flock($fp, LOCK_EX)){
			fwrite($fp, $postVal);
			fflush($fp);
			flock($fp, LOCK_UN);
		} else {
			$retVar = '#Error - failed to save file';
		}
		fclose($fp);
	}else {
		$expectedHash = $_POST['crc'];
		$fp = fopen($postKey, 'r+'); // 'r+' モードで読み取りおよび書き込み用に開く
		if(flock($fp, LOCK_EX)){ // 排他ロックを取得
			$fileSize = filesize($postKey);
			if($fileSize > 0){
				$content = fread($fp, filesize($postKey));
			}else {
				$content = '';
			}
			$currentHash = hash('crc32b', $content);
			if ($currentHash === $expectedHash) {
				ftruncate($fp, 0); // ファイルを空にする
				rewind($fp); // ファイルポインタを先頭に戻す
				fwrite($fp, $postVal);
				fflush($fp); // 出力バッファをフラッシュ
			} else {
				$retVar = '#Error - CRC32b hash does not match';
			}
			flock($fp, LOCK_UN); // ロックを解除
		} else {
			$retVar = '#Error - failed to save file';
		}
		fclose($fp);
	}
	return $retVar;
}
// ezphp_sql
function func_sql( $postKey, $postVal, $needsRetJson ){
	$prms = [];
	do {
		if(!isset($_POST['ph1'])) break;
		$prms[] = $_POST['ph1'];
		if(!isset($_POST['ph2'])) break;
		$prms[] = $_POST['ph2'];
		if(!isset($_POST['ph3'])) break;
		$prms[] = $_POST['ph3'];
		if(!isset($_POST['ph4'])) break;
		$prms[] = $_POST['ph4'];
		if(!isset($_POST['ph5'])) break;
		$prms[] = $_POST['ph5'];
		if(!isset($_POST['ph6'])) break;
		$prms[] = $_POST['ph6'];
		if(!isset($_POST['ph7'])) break;
		$prms[] = $_POST['ph7'];
		if(!isset($_POST['ph8'])) break;
		$prms[] = $_POST['ph8'];
		if(!isset($_POST['ph9'])) break;
		$prms[] = $_POST['ph9'];
	} while(false);
	try{
		$db = new PDO('sqlite:'.$postKey);
		$stmt = $db->prepare($postVal);
		$stmt->execute($prms);
		if( strtoupper(substr(trim($postVal),0,6)) == 'SELECT' ){
			if($needsRetJson){
				header('Content-Type: application/json; charset=utf-8');
				return json_encode($stmt->fetchAll(PDO::FETCH_ASSOC));
			}else {
				$isFirst = true;
				$retVar = '';
				while( $row = $stmt->fetch(PDO::FETCH_ASSOC) ){
					foreach ($row as $key => $value){
						if($isFirst){
							$isFirst = false;
						}else{
							$retVar .= "\r\n";
						}
						$retVar .= $key.':'.str_replace(["\r\n", "\r", "\n"], '<BR>', $value);
					}
				}
				return $retVar;
			}
		}
		return '';
	} catch (Exception $e) {
		echo '#Error - ' . $e->getMessage();
		exit;
	}
}